/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8273;

import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.eui.PropertyBook;
import java.awt.List;
import java.util.Enumeration;
import java.util.Vector;

public class EncodedNumberList {
    private Vector objectList;
    private boolean multiChoice;
    private List widget;
    private static String[] paddingArray = new String[]{"0000", "000", "00", "0"};

    public EncodedNumberList(boolean bl) {
        this.multiChoice = bl;
        this.objectList = new Vector();
        this.widget = new List(5, this.multiChoice);
        this.widget.setBackground(PropertyBook.selListBackColor);
        this.widget.setForeground(PropertyBook.selListForeColor);
    }

    public void buildInitialList(Vector vector, String string, String string2) {
        ListObject listObject;
        this.objectList.removeAllElements();
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ModelInfo modelInfo = (ModelInfo)enumeration.nextElement();
                if (!(modelInfo.get(string) instanceof Integer)) continue;
                int n = (Integer)modelInfo.get(string);
                String string3 = modelInfo.get(string2).toString();
                listObject = new ListObject(n, string3);
                this.objectList.addElement(listObject);
            }
        }
        this.widget.removeAll();
        int n = 0;
        while (n < this.objectList.size()) {
            listObject = (ListObject)this.objectList.elementAt(n);
            this.widget.addItem(listObject.getDescription());
            ++n;
        }
        this.widget.invalidate();
    }

    public List getWidget() {
        return this.widget;
    }

    public void selectFromEncodedList(OctetString octetString) {
        ListObject listObject;
        int n = 0;
        while (n < this.objectList.size()) {
            listObject = (ListObject)this.objectList.elementAt(n);
            listObject.setSelected(false);
            this.widget.deselect(n);
            ++n;
        }
        this.decodeOctetStringToObjectList(octetString);
        int n2 = 0;
        while (n2 < this.objectList.size()) {
            listObject = (ListObject)this.objectList.elementAt(n2);
            if (listObject.isSelected()) {
                this.widget.select(n2);
            }
            ++n2;
        }
    }

    public OctetString encodeSelection() {
        int n = 0;
        while (n < this.objectList.size()) {
            ListObject listObject = (ListObject)this.objectList.elementAt(n);
            listObject.setSelected(this.widget.isIndexSelected(n));
            ++n;
        }
        return this.encodeObjectListToOctetString();
    }

    public void selectFromValue(Integer n) {
        ListObject listObject;
        int n2 = 0;
        while (n2 < this.objectList.size()) {
            listObject = (ListObject)this.objectList.elementAt(n2);
            listObject.setSelected(false);
            this.widget.deselect(n2);
            ++n2;
        }
        this.decodeIntegerToObjectList(n);
        int n3 = 0;
        while (n3 < this.objectList.size()) {
            listObject = (ListObject)this.objectList.elementAt(n3);
            if (listObject.isSelected()) {
                this.widget.select(n3);
            }
            ++n3;
        }
    }

    public Integer encodeValue() {
        int n = 0;
        while (n < this.objectList.size()) {
            ListObject listObject = (ListObject)this.objectList.elementAt(n);
            listObject.setSelected(this.widget.isIndexSelected(n));
            ++n;
        }
        return this.encodeObjectListToInteger();
    }

    private void decodeOctetStringToObjectList(OctetString octetString) {
        String string = octetString.toString();
        int n = 0;
        while (n < string.length()) {
            String string2 = string.substring(n, n + 2);
            try {
                int n2 = Integer.parseInt(string2, 16);
                Enumeration enumeration = this.objectList.elements();
                while (enumeration.hasMoreElements()) {
                    ListObject listObject = (ListObject)enumeration.nextElement();
                    if (listObject.getKey() != n2) continue;
                    listObject.setSelected(true);
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Unexpected data format returned in ATM Services octet string:" + string);
            }
            n += 2;
        }
    }

    private OctetString encodeObjectListToOctetString() {
        OctetString octetString = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.objectList.size()) {
            ListObject listObject = (ListObject)this.objectList.elementAt(n);
            if (listObject.isSelected()) {
                String string = Integer.toHexString(listObject.getKey());
                String string2 = null;
                if (string.length() < 4) {
                    string2 = paddingArray[string.length()];
                }
                stringBuffer.append(string2);
                stringBuffer.append(string);
            }
            ++n;
        }
        if (stringBuffer.length() != 0) {
            octetString = new OctetString(stringBuffer.toString());
        }
        return octetString;
    }

    private void decodeIntegerToObjectList(Integer n) {
        int n2 = n;
        Enumeration enumeration = this.objectList.elements();
        while (enumeration.hasMoreElements()) {
            ListObject listObject = (ListObject)enumeration.nextElement();
            if (listObject.getKey() != n2) continue;
            listObject.setSelected(true);
        }
    }

    private Integer encodeObjectListToInteger() {
        int n = 0;
        Integer n2 = null;
        boolean bl = false;
        Enumeration enumeration = this.objectList.elements();
        while (enumeration.hasMoreElements() && !bl) {
            ListObject listObject = (ListObject)enumeration.nextElement();
            if (!listObject.isSelected()) continue;
            n = listObject.getKey();
            bl = true;
        }
        if (bl) {
            n2 = new Integer(n);
        }
        return n2;
    }

    private class ListObject {
        int key;
        String description;
        boolean selected;

        ListObject(int n, String string) {
            EncodedNumberList.this = EncodedNumberList.this;
            this.key = n;
            this.description = String.valueOf(String.valueOf(n)) + "  " + string;
            this.selected = false;
        }

        int getKey() {
            return this.key;
        }

        String getDescription() {
            return this.description;
        }

        boolean isSelected() {
            return this.selected;
        }

        void setSelected(boolean bl) {
            this.selected = bl;
        }
    }
}

